package watch_graph //nolint:staticcheck

import (
	storagev1 "k8s.io/api/storage/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectVolumeAttachmentV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[storagev1.VolumeAttachment](obj)
	if err != nil {
		return err
	}

	if o.Spec.Source.PersistentVolumeName != nil {
		vx.setArcToGVK(
			persistentVolumeGVK,
			*o.Spec.Source.PersistentVolumeName,
			ArcAttrs{},
			ReferenceArcType,
		)
	}

	if o.Spec.Source.InlineVolumeSpec != nil {
		vx.collectPersistentVolumeSpecV1Arcs(o.Spec.Source.InlineVolumeSpec, ReferenceArcType)
	}

	vx.setArcToGVK(nodeGVK, o.Spec.NodeName, ArcAttrs{}, ReferenceArcType)

	return nil
}
