package watch_graph //nolint:staticcheck

import (
	rbacv1 "k8s.io/api/rbac/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectRoleBindingV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[rbacv1.RoleBinding](obj)
	if err != nil {
		return err
	}
	vx.setArcTo(o.RoleRef.APIGroup, o.RoleRef.Kind, o.RoleRef.Name, "", ArcAttrs{}, ReferenceArcType)

	collectEach(o.Subjects, ReferenceArcType, vx.collectRBACSubjectV1Arcs)

	return nil
}

func (vx *wgObject2vertex) collectRBACSubjectV1Arcs(s *rbacv1.Subject, arcType ArcType) {
	switch s.Kind {
	case "ServiceAccount":
		vx.setArcTo(serviceAccountGVK.Group, serviceAccountGVK.Kind, s.Name, s.Namespace, ArcAttrs{}, arcType)
	}
}
