package watch_graph //nolint:staticcheck

import (
	appsv1 "k8s.io/api/apps/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectReplicaSetV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[appsv1.ReplicaSet](obj)
	if err != nil {
		return err
	}

	// ReplicaSet transitively references things in the Pod's spec. Hence, use transitive ref type.
	vx.collectPodSpecV1Arcs(&o.Spec.Template.Spec, TransitiveReferenceArcType)

	return nil
}
