package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/utils/ptr"
)

func (vx *wgObject2vertex) collectPersistentVolumeClaimV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.PersistentVolumeClaim](obj)
	if err != nil {
		return err
	}
	vx.collectPersistentVolumeClaimSpecV1Arcs(&o.Spec, ReferenceArcType)
	return nil
}

func (vx *wgObject2vertex) collectPersistentVolumeClaimSpecV1Arcs(spec *corev1.PersistentVolumeClaimSpec, arcType ArcType) {
	vx.setArcToGVK(persistentVolumeGVK, spec.VolumeName, ArcAttrs{}, arcType)
	if spec.StorageClassName != nil {
		vx.setArcToGVK(storageClassGVK, *spec.StorageClassName, ArcAttrs{}, arcType)
	}
	if spec.DataSource != nil {
		vx.setArcTo(
			ptr.Deref(spec.DataSource.APIGroup, ""),
			spec.DataSource.Kind,
			spec.DataSource.Name,
			"",
			ArcAttrs{},
			arcType,
		)
	}
	if spec.DataSourceRef != nil {
		vx.setArcTo(
			ptr.Deref(spec.DataSourceRef.APIGroup, ""),
			spec.DataSourceRef.Kind,
			spec.DataSourceRef.Name,
			ptr.Deref(spec.DataSourceRef.Namespace, ""),
			ArcAttrs{},
			arcType,
		)
	}
	if spec.VolumeAttributesClassName != nil {
		vx.setArcToGVK(volumeAttributesClassV1Beta1GVK, *spec.VolumeAttributesClassName, ArcAttrs{}, arcType)
	}
}
