package watch_graph //nolint:staticcheck

import (
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	autoscalingv2 "k8s.io/api/autoscaling/v2"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectHorizontalPodAutoscalerV1Arcs(obj *unstructured.Unstructured) *Error {
	o, errX := unstructuredToTyped[autoscalingv1.HorizontalPodAutoscaler](obj)
	if errX != nil {
		return errX
	}

	gv, err := schema.ParseGroupVersion(o.Spec.ScaleTargetRef.APIVersion)
	if err != nil {
		vx.appendObjectProcessingWarning(err.Error())
		return nil
	}

	vx.setArcTo(gv.Group, o.Spec.ScaleTargetRef.Kind, o.Spec.ScaleTargetRef.Name, "", ArcAttrs{}, ReferenceArcType)
	return nil
}

func (vx *wgObject2vertex) collectHorizontalPodAutoscalerV2Arcs(obj *unstructured.Unstructured) *Error {
	o, errX := unstructuredToTyped[autoscalingv2.HorizontalPodAutoscaler](obj)
	if errX != nil {
		return errX
	}

	gv, err := schema.ParseGroupVersion(o.Spec.ScaleTargetRef.APIVersion)
	if err != nil {
		vx.appendObjectProcessingWarning(err.Error())
		return nil
	}

	vx.setArcTo(gv.Group, o.Spec.ScaleTargetRef.Kind, o.Spec.ScaleTargetRef.Name, "", ArcAttrs{}, ReferenceArcType)
	return nil
}
