package watch_graph //nolint:staticcheck

import (
	sourcev1 "github.com/fluxcd/source-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerBucketV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.Bucket](obj)
	if err != nil {
		return err
	}

	if o.Spec.SecretRef != nil {
		vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.ProxySecretRef != nil {
		vx.setArcToSecret(o.Spec.ProxySecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.CertSecretRef != nil {
		vx.setArcToSecret(o.Spec.CertSecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.STS != nil {
		if o.Spec.STS.SecretRef != nil {
			vx.setArcToSecret(o.Spec.STS.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
		}

		if o.Spec.STS.CertSecretRef != nil {
			vx.setArcToSecret(o.Spec.STS.CertSecretRef.Name, ArcAttrs{}, ReferenceArcType)
		}
	}

	return nil
}
