package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
)

func (vx *wgObject2vertex) collectEnvFromSourceV1Arcs(e *corev1.EnvFromSource, arcType ArcType) {
	if e.ConfigMapRef != nil {
		vx.setArcToConfigMap(e.ConfigMapRef.Name, ArcAttrs{}, arcType)
	}
	if e.SecretRef != nil {
		vx.setArcToSecret(e.SecretRef.Name, ArcAttrs{}, arcType)
	}
}
