package rpc

import (
	"k8s.io/apimachinery/pkg/util/sets"
)

func ReconcileProjectsFromSet(projects sets.Set[string]) []*Project {
	ps := make([]*Project, 0, len(projects))
	for p := range projects {
		ps = append(ps, &Project{Id: p})
	}
	return ps
}

func (x *ReconcileProjectsRequest) ToProjectSet() sets.Set[string] {
	if x == nil {
		return nil
	}

	projects := make(sets.Set[string], len(x.Project))
	for _, p := range x.Project {
		projects.Insert(p.Id)
	}
	return projects
}
