package agent

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCollectExtraTelemetryData(t *testing.T) {
	// GIVEN
	environ := []string{
		"UNRELATED=foo",
		"GITLAB_UNRELATED=bar",
		"INVALID",
		"GITLAB_AGENT_TELEMETRY_KEY=some-value",
		"GITLAB_AGENT_TELEMETRY_ANOTHER_KEY=",
	}

	// WHEN
	data := CollectExtraTelemetryData(environ)

	// THEN
	assert.Equal(t, map[string]string{
		"KEY":         "some-value",
		"ANOTHER_KEY": "",
	}, data)
}
