package agent

import (
	"context"
	"log/slog"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/tool/logz"
)

type scanJob struct {
	log              *slog.Logger
	scanner          Scanner
	namespaceScanner NamespaceScanner
	reporter         Reporter
}

func (s *scanJob) Run(ctx context.Context) {
	if err := s.scanner.scan(ctx, s.namespaceScanner, s.reporter); err != nil {
		s.log.Error("Error running vulnerability scan", logz.Error(err))
	}
}
