package agent

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/module/modagent"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/pkg/entity"
)

func TestGetAgentNamespaceAndServiceAccount(t *testing.T) {
	testCases := []struct {
		description            string
		inputNamespace         string
		expectedNamespace      string
		inputServiceAccount    string
		expectedServiceAccount string
	}{
		{
			description:            "Default namespace and default service account",
			inputNamespace:         "",
			inputServiceAccount:    "",
			expectedNamespace:      "gitlab-agent",
			expectedServiceAccount: "gitlab-agent",
		},
		{
			description:            "Custom service account",
			inputNamespace:         "",
			inputServiceAccount:    "custom-account",
			expectedNamespace:      "gitlab-agent",
			expectedServiceAccount: "custom-account",
		},
		{
			description:            "Custom namespace",
			inputNamespace:         "custom-namespace",
			inputServiceAccount:    "",
			expectedNamespace:      "custom-namespace",
			expectedServiceAccount: "gitlab-agent",
		},
		{
			description:            "Custom namespace and account",
			inputNamespace:         "custom-namespace",
			inputServiceAccount:    "custom-account",
			expectedNamespace:      "custom-namespace",
			expectedServiceAccount: "custom-account",
		},
	}

	for _, tc := range testCases {
		t.Run(tc.description, func(t *testing.T) {
			cfg := getAgentConfig(tc.inputNamespace, tc.inputServiceAccount)
			assert.Equal(t, tc.expectedNamespace, getAgentNamespace(cfg))
			assert.Equal(t, tc.expectedServiceAccount, getAgentServiceAccount(cfg))
		})
	}
}

func getAgentConfig(podNamespace string, serviceAccountName string) *modagent.Config {
	return &modagent.Config{
		AgentMeta: &entity.AgentMeta{
			Version:      "v1.2.3",
			GitRef:       "0123456789abcdef0123456789abcdef00000000",
			PodNamespace: podNamespace,
			PodName:      "n1",
		},
		ServiceAccountName: serviceAccountName,
	}
}
