package agent_tracker //nolint:stylecheck

import (
	"testing"
	"time"

	"github.com/stretchr/testify/require"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/tool/redistool"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/pkg/entity"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/timestamppb"
)

func TestConnectedAgentInfoSize(t *testing.T) {
	infoBytes, err := proto.Marshal(&ConnectedAgentInfo{
		AgentMeta: &entity.AgentMeta{
			Version:      "v1.0.0",
			GitRef:       "0123456789abcdef0123456789abcdef00000000",
			PodNamespace: "gitlab-agent",
			PodName:      "agentk-g7x6j",
		},
		ConnectedAt:  timestamppb.Now(),
		ConnectionId: 1231232,
		AgentId:      123123,
		ProjectId:    3232323,
	})
	require.NoError(t, err)
	data, err := proto.Marshal(&redistool.ExpiringValue{
		ExpiresAt: time.Now().Unix(),
		Value:     infoBytes,
	})
	require.NoError(t, err)
	t.Log(len(data))
}
