package server

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/module/agent_registrar"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/module/agent_registrar/rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/module/agent_tracker"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v17/internal/module/modserver"
)

const registerAgentEventName = "register_agent_at_kas"

type Factory struct {
	AgentRegisterer agent_tracker.ExpiringRegisterer
}

func (f *Factory) New(config *modserver.Config) (modserver.Module, error) {
	rpc.RegisterAgentRegistrarServer(config.AgentServer, &server{
		agentRegisterer:           f.AgentRegisterer,
		registerAgentEventTracker: config.EventTracker.RegisterEvent(registerAgentEventName),
	})

	return nil, nil
}

func (f *Factory) Name() string {
	return agent_registrar.ModuleName
}
