pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_weight_equals_null() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = null")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = null")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_equals_none_token() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_not_equals_number() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != 2")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(not: {weight: \"2\"}, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != 2")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(not: {weight: \"2\"}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_equals_any_token() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_not_equals_any_token() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != any")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != any")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_not_equals_none_token() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != none")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight != none")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_weight_equals_number() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = 2")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(weight: \"2\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and weight = 2")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(weight: \"2\", before: $before, after: $after, first: $limit) {"
    );
}
