pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_upcoming() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and milestone = upcoming")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(milestoneWildcardId: UPCOMING, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and milestone = upcoming")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(milestoneWildcardId: UPCOMING, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_started() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and milestone = started")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(milestoneWildcardId: STARTED, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and milestone = started")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(milestoneWildcardId: STARTED, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_current() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = current")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iterationWildcardId: CURRENT, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = current")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iterationWildcardId: CURRENT, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_any_iteration() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iterationWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iterationWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_any_with_label() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and label = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(labelName: \"ANY\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and label = any")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(labelName: \"ANY\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_none_iteration() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iterationWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iterationWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_none_with_assignee() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and assignee = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and assignee = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_none_with_label() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and label = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(labelName: \"NONE\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and label = none")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(labelName: \"NONE\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_case_insensitive_tokens() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and assignee = nONe")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and assignee = nONe")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_case_insensitive_any() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = AnY")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iterationWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = AnY")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iterationWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_case_insensitive_current() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = CuRrEnT")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iterationWildcardId: CURRENT, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and iteration = CuRrEnT")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iterationWildcardId: CURRENT, before: $before, after: $after, first: $limit) {"
    );
}
