pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_status_equals_something() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and status = \"Start\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(status: {name: \"Start\"}, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and status = \"Start\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(status: {name: \"Start\"}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_status_not_equals_something() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and status != \"Start\""),
        "Error: `status` does not support the not equals (`!=`) operator. Supported operators: equals (`=`)."
    );
}
