pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_opened_gt_datetime() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened > \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(createdAfter: \"2024-02-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened > \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(createdAfter: \"2024-02-01 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_opened_lt_datetime() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened < \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(createdBefore: \"2024-02-01 00:00\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened < \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(createdBefore: \"2024-02-01 00:00\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_closed_gt_datetime() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed > \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(closedAfter: \"2024-02-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed > \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(closedAfter: \"2024-02-01 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_closed_lt_datetime() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed < \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(closedBefore: \"2024-02-01 00:00\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed < \"2024-02-01\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(closedBefore: \"2024-02-01 00:00\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_state_equals_opened() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state = opened")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(state: opened, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state = opened")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(state: opened, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_state_equals_closed() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state = closed")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(state: closed, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state = closed")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(state: closed, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn state_not_equals_opened() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state != opened"),
        "Error: `state` does not support the not equals (`!=`) operator. Supported operators: equals (`=`)."
    );
}

#[test]
fn state_equals_invalid() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and state = \"invalid\""),
        "Error: `state` cannot be compared with `\"invalid\"`. Supported value types: `Enum` (`opened`, `closed`, `all`)."
    );
}

#[test]
fn test_opened_equals_true() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened = true"),
        "Error: `opened` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?"
    );
}

#[test]
fn test_opened_equals_false() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and opened = false"),
        "Error: `opened` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = closed`?"
    );
}

#[test]
fn test_created_equals_true() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and created = true"),
        "Error: `created` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?"
    );
}

#[test]
fn test_created_equals_false() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and created = false"),
        "Error: `created` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = closed`?"
    );
}

#[test]
fn test_closed_equals_true() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed = true"),
        "Error: `closed` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = closed`?"
    );
}

#[test]
fn test_closed_equals_false() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and closed = false"),
        "Error: `closed` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = opened`?"
    );
}
