pub mod test_helpers;

use crate::test_helpers::*;
use glql::types::Source::*;

macro_rules! test {
    ($($name:ident: $value:expr,)*) => { $(
        #[test]
        fn $name() {
                let compiled = compile_with_source(MergeRequests, format!("project = \"gitlab-org/gitlab\" and {}", $value.0).as_str());
            assert_eq!(
                compiled.lines().nth(2).unwrap_or_else(|| compiled.as_str()),
                $value.1
            );
        }
    )* }
}

// success cases
test! {
    test_id_equals_number: (
        "id = 1",
         "    mergeRequests(iids: \"1\", before: $before, after: $after, first: $limit) {"
    ),
    test_id_in_list_of_numbers: (
        "id in (1, 2, 3)",
         "    mergeRequests(iids: [\"1\", \"2\", \"3\"], before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_equals_username: (
        "assignee = @johndoe",
         "    mergeRequests(assigneeUsername: \"johndoe\", before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_equals_string: (
        "assignee = \"foo\"",
         "    mergeRequests(assigneeUsername: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_equals_any: (
        "assignee = any",
         "    mergeRequests(assigneeWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_not_equals_any: (
        "assignee != any",
         "    mergeRequests(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_equals_none: (
        "assignee = none",
         "    mergeRequests(assigneeWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_not_equals_none: (
        "assignee != none",
         "    mergeRequests(assigneeWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    ),
    test_assignee_not_equals_username: (
        "assignee != @johndoe",
         "    mergeRequests(not: {assigneeUsernames: \"johndoe\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_equals_username: (
        "reviewer = @johndoe",
         "    mergeRequests(reviewerUsername: \"johndoe\", before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_equals_string: (
        "reviewer = \"foo\"",
         "    mergeRequests(reviewerUsername: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_equals_any: (
        "reviewer = any",
         "    mergeRequests(reviewerWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_not_equals_any: (
        "reviewer != any",
         "    mergeRequests(reviewerWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_equals_none: (
        "reviewer = none",
         "    mergeRequests(reviewerWildcardId: NONE, before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_not_equals_none: (
        "reviewer != none",
         "    mergeRequests(reviewerWildcardId: ANY, before: $before, after: $after, first: $limit) {"
    ),
    test_reviewer_not_equals_username: (
        "reviewer != @johndoe",
         "    mergeRequests(not: {reviewerUsername: \"johndoe\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_author_equals_username: (
        "author = @johndoe",
         "    mergeRequests(authorUsername: \"johndoe\", before: $before, after: $after, first: $limit) {"
    ),
    test_author_not_equals_string: (
        "author != \"foo\"",
         "    mergeRequests(not: {authorUsername: \"foo\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_approver_equals_username: (
        "approver = @johndoe",
         "    mergeRequests(approvedBy: \"johndoe\", before: $before, after: $after, first: $limit) {"
    ),
    test_aprover_not_equals_string: (
        "approver != \"foo\"",
         "    mergeRequests(not: {approvedBy: \"foo\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_approver_not_in_list: (
        "approver != (@foo, @bar)",
         "    mergeRequests(not: {approvedBy: [\"foo\", \"bar\"]}, before: $before, after: $after, first: $limit) {"
    ),
    test_merger_equals_username: (
        "merger = @johndoe",
         "    mergeRequests(mergedBy: \"johndoe\", before: $before, after: $after, first: $limit) {"
    ),
    test_merger_equals_string: (
        "merger = \"foo\"",
         "    mergeRequests(mergedBy: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_draft_equals_true: (
        "draft = true",
         "    mergeRequests(draft: true, before: $before, after: $after, first: $limit) {"
    ),
    test_draft_equals_false: (
        "draft = false",
         "    mergeRequests(draft: false, before: $before, after: $after, first: $limit) {"
    ),
    test_draft_not_equals_true: (
        "draft != true",
         "    mergeRequests(draft: false, before: $before, after: $after, first: $limit) {"
    ),
    test_state_equals_opened: (
        "state = OPENED",
         "    mergeRequests(state: opened, before: $before, after: $after, first: $limit) {"
    ),
    test_state_equals_closed: (
        "state = closed",
         "    mergeRequests(state: closed, before: $before, after: $after, first: $limit) {"
    ),
    test_state_equals_all: (
        "state = ALL",
         "    mergeRequests(state: all, before: $before, after: $after, first: $limit) {"
    ),
    test_state_equals_merged: (
        "state = MERGED",
         "    mergeRequests(state: merged, before: $before, after: $after, first: $limit) {"
    ),
    test_created_after: (
        "created > 2020-01-01",
         "    mergeRequests(createdAfter: \"2020-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    ),
    test_created_before: (
        "created < 2020-01-01",
         "    mergeRequests(createdBefore: \"2020-01-01 00:00\", before: $before, after: $after, first: $limit) {"
    ),
    test_created_gte: (
        "created >= 2020-01-01",
         "    mergeRequests(createdAfter: \"2020-01-01 00:00\", before: $before, after: $after, first: $limit) {"
    ),
    test_created_lte: (
        "created <= 2020-01-01",
         "    mergeRequests(createdBefore: \"2020-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    ),
    test_merged_after: (
        "merged > 2020-01-01",
         "    mergeRequests(mergedAfter: \"2020-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    ),
    test_merged_before: (
        "merged < 2020-01-01",
         "    mergeRequests(mergedBefore: \"2020-01-01 00:00\", before: $before, after: $after, first: $limit) {"
    ),
    test_deployed_after: (
        "deployed > 2020-01-01",
         "    mergeRequests(deployedAfter: \"2020-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    ),
    test_deployed_before: (
        "deployed < \"2020-01-01\"",
         "    mergeRequests(deployedBefore: \"2020-01-01 00:00\", before: $before, after: $after, first: $limit) {"
    ),
    test_label_equals_string: (
        "label = \"foo\"",
         "    mergeRequests(labelName: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_label_equals_label: (
        "label = ~foo",
         "    mergeRequests(labelName: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_label_equals_list: (
        "label = (\"foo\", \"bar\")",
         "    mergeRequests(labelName: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {",
    ),
    test_label_not_equals_list: (
        "label != (~foo, ~bar)",
         "    mergeRequests(not: {labelName: [\"foo\", \"bar\"]}, before: $before, after: $after, first: $limit) {"
    ),
    test_environment_equals_string: (
        "environment = \"gprd\"",
         "    mergeRequests(environmentName: \"gprd\", before: $before, after: $after, first: $limit) {"
    ),
    test_milesone_equals_milestone: (
        "milestone = %12.4",
         "    mergeRequests(milestoneTitle: \"12.4\", before: $before, after: $after, first: $limit) {"
    ),
    test_milestone_equals_any: (
        "milestone = any",
         "    mergeRequests(milestoneWildcardId: ANY, before: $before, after: $after, first: $limit) {",
    ),
    test_milestone_equals_none: (
        "milestone = none",
         "    mergeRequests(milestoneWildcardId: NONE, before: $before, after: $after, first: $limit) {",
    ),
    test_milestone_not_equals_none: (
        "milestone != none",
         "    mergeRequests(milestoneWildcardId: ANY, before: $before, after: $after, first: $limit) {",
    ),
    test_source_branch_equals_string: (
        "sourceBranch = \"foo\"",
         "    mergeRequests(sourceBranches: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_target_branch_equals_string: (
        "targetBranch = \"foo\"",
         "    mergeRequests(targetBranches: \"foo\", before: $before, after: $after, first: $limit) {"
    ),
    test_source_branch_not_equals_string: (
        "sourceBranch != \"foo\"",
         "    mergeRequests(not: {sourceBranches: \"foo\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_target_branch_not_equals_string: (
        "targetBranch != \"foo\"",
         "    mergeRequests(not: {targetBranches: \"foo\"}, before: $before, after: $after, first: $limit) {"
    ),
    test_source_branch_in_list: (
        "sourceBranch in (\"foo\", \"bar\")",
         "    mergeRequests(sourceBranches: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {",
    ),
    test_target_branch_in_list: (
        "targetBranch in (\"foo\", \"bar\")",
         "    mergeRequests(targetBranches: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {",
    ),
    test_source_branch_not_equals_list: (
        "sourceBranch != (\"foo\", \"bar\")",
         "    mergeRequests(not: {sourceBranches: [\"foo\", \"bar\"]}, before: $before, after: $after, first: $limit) {"
    ),
    test_target_branch_not_equals_list: (
        "targetBranch != (\"foo\", \"bar\")",
         "    mergeRequests(not: {targetBranches: [\"foo\", \"bar\"]}, before: $before, after: $after, first: $limit) {"
    ),
}

// failure cases
test! {
    test_id_equals_list_of_numbers: (
        "id = (1, 2, 3)",
        "Error: `id` does not support the equals (`=`) operator for `(1, 2, 3)`. Supported operators: is one of (`in`)."
    ),
    test_assignee_equals_number: (
        "assignee = 123",
        "Error: `assignee` cannot be compared with `123`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    ),
    test_assignee_equals_list: (
        "assignee = (@foo, @bar)",
        "Error: `assignee` cannot be compared with `(@foo, @bar)`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    ),
    test_assignee_in: (
        "assignee in (@foo, @bar)",
        "Error: `assignee` does not support the is one of (`in`) operator. Supported operators: equals (`=`), not equals (`!=`)."
    ),
    test_reviewer_equals_number: (
        "reviewer = 123",
        "Error: `reviewer` cannot be compared with `123`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    ),
    test_reviewer_equals_list: (
        "reviewer = (@foo, @bar)",
        "Error: `reviewer` cannot be compared with `(@foo, @bar)`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    ),
    test_reviewer_in: (
        "reviewer in (@foo, @bar)",
        "Error: `reviewer` does not support the is one of (`in`) operator. Supported operators: equals (`=`), not equals (`!=`)."
    ),
    test_author_equals_any: (
        "author = any",
        "Error: `author` cannot be compared with `ANY`. Supported value types: `String`, `Username` (example: `@username`)."
    ),
    test_approver_in_list: (
        "approver in (@foo, @bar)",
        "Error: `approver` does not support the is one of (`in`) operator. Supported operators: equals (`=`), not equals (`!=`)."
    ),
    test_merger_in_list: (
        "merger in (@foo, @bar)",
        "Error: `merger` does not support the is one of (`in`) operator. Supported operators: equals (`=`)."
    ),
    test_draft_equals_string: (
        "draft = \"foo\"",
        "Error: `draft` cannot be compared with `\"foo\"`. Supported value types: `Boolean` (`true`, `false`)."
    ),
    test_state_equals_any: (
        "state = any",
        "Error: `state` cannot be compared with `ANY`. Supported value types: `Enum` (`opened`, `closed`, `merged`, `all`)."
    ),
    test_state_not_equals_merged: (
        "state != merged",
        "Error: `state` does not support the not equals (`!=`) operator. Supported operators: equals (`=`)."
    ),
    test_created_equals_true: (
        "created = true",
        "Error: `created` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?"
    ),
    test_opened_equals_true: (
        "opened = true",
        "Error: `opened` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?"
    ),
    test_deployed_equals_string: (
        "deployed = \"foo\"",
        "Error: `deployed` cannot be compared with `\"foo\"`. Supported value types: `Date`."
    ),
    test_environment_equals_number: (
        "environment = 123",
        "Error: `environment` cannot be compared with `123`. Supported value types: `String`."
    ),
    test_environment_not_equals_string: (
        "environment != \"foo\"",
        "Error: `environment` does not support the not equals (`!=`) operator. Supported operators: equals (`=`)."
    ),
    test_label_in_list: (
        "label in (~foo, ~bar)",
        "Error: `label` does not support the is one of (`in`) operator. Supported operators: equals (`=`), not equals (`!=`)."
    ),
    test_milestone_in_list: (
        "milestone in (%12.4, %12.5)",
        "Error: `milestone` does not support the is one of (`in`) operator. Supported operators: equals (`=`), not equals (`!=`)."
    ),
    test_source_branch_equals_list: (
        "sourceBranch = (\"foo\", \"bar\")",
        "Error: `sourceBranch` does not support the equals (`=`) operator for `(\"foo\", \"bar\")`. Supported operators: is one of (`in`), not equals (`!=`)."
    ),
    test_target_branch_equals_list: (
        "targetBranch = (\"foo\", \"bar\")",
        "Error: `targetBranch` does not support the equals (`=`) operator for `(\"foo\", \"bar\")`. Supported operators: is one of (`in`), not equals (`!=`)."
    ),
}
