pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_id_equals_number() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id = 1")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iids: \"1\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id = 1")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iids: \"1\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_id_in_list_of_numbers() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id in (1, 2, 3)")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(iids: [\"1\", \"2\", \"3\"], before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id in (1, 2, 3)")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(iids: [\"1\", \"2\", \"3\"], before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_id_not_equals_number() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id != 1"),
        "Error: `id` does not support the not equals (`!=`) operator. Supported operators: equals (`=`), is one of (`in`)."
    );
}

#[test]
fn test_id_equals_list() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id = (1, 2, 3)"),
        "Error: `id` does not support the equals (`=`) operator for `(1, 2, 3)`. Supported operators: is one of (`in`)."
    )
}

#[test]
fn test_id_equals_string_list() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and id = (\"1\", \"2\", \"3\")"),
        "Error: `id` cannot be compared with `(\"1\", \"2\", \"3\")`. Supported value types: `Number`, `List`."
    )
}
