pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_health_equals_at_risk() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"at risk\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(healthStatusFilter: atRisk, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"at risk\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(healthStatusFilter: atRisk, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_health_equals_needs_attention() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"needs attention\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(healthStatusFilter: needsAttention, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"needs attention\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(healthStatusFilter: needsAttention, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_health_equals_on_track() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"on track\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(healthStatusFilter: onTrack, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"on track\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(healthStatusFilter: onTrack, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_health_not_equals() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health != \"at risk\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(not: {healthStatusFilter: atRisk}, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health != \"at risk\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(not: {healthStatusFilter: atRisk}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_health_status_case_insensitive() {
    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"NeEds attEntioN\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    issues(healthStatusFilter: needsAttention, before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_graphql("project = \"gitlab-org/gitlab\" and health = \"NeEds attEntioN\"")
            .lines()
            .nth(2)
            .unwrap(),
        "    workItems(healthStatusFilter: needsAttention, before: $before, after: $after, first: $limit) {"
    );
}
