pub mod test_helpers;

use crate::test_helpers::*;

#[test]
fn test_response_with_labels() {
    let response = compile_with_fields("label = \"foo\"", &["labels"]);
    assert!(response.contains("labels {"));
    assert!(response.contains("nodes {"));
    assert!(response.contains("id"));
    assert!(response.contains("title"));
    assert!(response.contains("color"));
    assert!(response.contains("textColor"));
}

#[test]
fn test_response_with_assignees() {
    let response = compile_with_fields("assignee = \"foo\"", &["assignees"]);
    assert!(response.contains("assignees {"));
    assert!(response.contains("nodes {"));
    assert!(response.contains("id"));
    assert!(response.contains("avatarUrl"));
    assert!(response.contains("username"));
    assert!(response.contains("name"));
    assert!(response.contains("webUrl"));
}

#[test]
fn test_response_with_milestone() {
    let response = compile_with_fields("milestone = \"foo\"", &["milestone"]);
    assert!(response.contains("milestone {"));
    assert!(response.contains("id"));
    assert!(response.contains("iid"));
    assert!(response.contains("dueDate"));
    assert!(response.contains("startDate"));
    assert!(response.contains("title"));
    assert!(response.contains("webPath"));
}

#[test]
fn test_response_with_iteration() {
    let response = compile_with_fields("iteration = \"foo\"", &["iteration"]);
    assert!(response.contains("iteration {"));
    assert!(response.contains("id"));
    assert!(response.contains("iid"));
    assert!(response.contains("startDate"));
    assert!(response.contains("dueDate"));
    assert!(response.contains("title"));
    assert!(response.contains("webUrl"));
    assert!(response.contains("iterationCadence {"));
    assert!(response.contains("id"));
    assert!(response.contains("title"));
}

#[test]
fn test_response_with_author() {
    let response = compile_with_fields("author = \"foo\"", &["author"]);
    assert!(response.contains("author {"));
    assert!(response.contains("id"));
    assert!(response.contains("avatarUrl"));
    assert!(response.contains("username"));
    assert!(response.contains("name"));
    assert!(response.contains("webUrl"));
}

#[test]
fn test_response_with_epic() {
    let response = compile_with_fields("epic = \"foo\"", &["epic"]);
    assert!(response.contains("epic {"));
    assert!(response.contains("id"));
    assert!(response.contains("iid"));
    assert!(response.contains("reference"));
    assert!(response.contains("state"));
    assert!(response.contains("title"));
    assert!(response.contains("webUrl"));
}

#[test]
fn test_response_with_task_completion() {
    let response = compile_with_fields("epic = \"foo\"", &["taskCompletionStatus"]);
    assert!(response.contains("taskCompletionStatus {"));
    assert!(response.contains("completedCount"));
    assert!(response.contains("count"));
}

#[test]
fn test_multiple_in_array() {
    assert_eq!(
        compile_graphql("label in (\"foo\") and assignee in (\"bar\")")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(or: {assigneeUsernames: [\"bar\"], labelNames: [\"foo\"]}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_multiple_not_equal() {
    assert_eq!(
        compile_graphql("label != (\"foo\") and assignee != \"bar\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(not: {assigneeUsernames: \"bar\", labelName: [\"foo\"]}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_multiple_same_not_equal() {
    assert_eq!(
        compile_graphql("label != (\"foo\") and label != \"bar\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(not: {labelName: [\"foo\", \"bar\"]}, before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_query_group_default() {
    let response = compile_with_group_context("bar", "weight=1");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  group(fullPath: \"bar\") {"
    );
}

#[test]
fn test_query_group_precedence() {
    let response = compile_with_group_context("bar", "group=\"foo\"");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  group(fullPath: \"foo\") {"
    );
}

#[test]
fn test_query_group_precedence_over_default_project() {
    let response = compile_with_group_context("bar", "group=\"foo\"");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  group(fullPath: \"foo\") {"
    );
}

#[test]
fn test_query_project_default() {
    let response = compile_with_project_context("bar", "weight=1");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  project(fullPath: \"bar\") {"
    );
}

#[test]
fn test_query_project_precedence() {
    let response = compile_with_project_context("bar", "project=\"foo\"");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  project(fullPath: \"foo\") {"
    );
}

#[test]
fn test_query_project_precedence_over_default_group() {
    let response = compile_with_project_context("bar", "project=\"foo\"");
    assert_eq!(
        response.lines().nth(1).unwrap(),
        "  project(fullPath: \"foo\") {"
    );
}
