pub mod test_helpers;

use crate::test_helpers::*;

#[test]
fn test_current_user_with_username() {
    assert_eq!(
        compile_with_user_context("foo", "assignee = currentUser()")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(assigneeUsernames: \"foo\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_current_user_without_username() {
    assert_eq!(
        compile_with_user_context("", "assignee=currentUser()")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(assigneeUsernames: \"\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_current_user_with_other_filters() {
    assert_eq!(
        compile_with_user_context(
            "bar",
            "assignee = currentUser() AND label = \"devops::plan\""
        )
        .lines()
        .nth(1)
        .unwrap(),
        "  issues(assigneeUsernames: \"bar\", labelName: \"devops::plan\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_days() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 3d")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-11-26 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_weeks() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 1w")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-11-30 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_months() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 1m")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-12-23 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_years() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 1y")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-11-23 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_negative() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > -1w")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-11-16 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_multiple_months() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 4m")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-03-23 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_months_over_year() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 12m")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-11-23 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_months_outside_bounds() {
    assert_eq!(
        compile_with_time_from_string("2023-04-30", "created > -2m")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-02-28 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_literal_months_leap_year() {
    assert_eq!(
        compile_with_time_from_string("2024-04-30", "created > -2m")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-02-29 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_date_literal() {
    assert_eq!(
        compile_with_time_from_string("2023-11-23", "created > 2023-11-26")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-11-26 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_current_user_special_chars() {
    assert_eq!(
        compile_with_user_context("user.name-123", "assignee = currentUser()")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(assigneeUsernames: \"user.name-123\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_date_function_timezone() {
    assert_eq!(
        compile_with_time_from_string("2024-03-10", "created > today()")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-03-10 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_relative_date_dst_transition() {
    assert_eq!(
        compile_with_time_from_string("2024-03-09", "created > 2d")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2024-03-11 23:59\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_date_literal_malformed_year() {
    assert_eq!(
        compile_graphql("created > 20231-11-26"),
        "Error: Invalid date format '20231-11-26'. Expected format: yyyy-mm-dd"
    );
}

#[test]
fn test_date_literal_missing_month() {
    assert_eq!(
        compile_graphql("created > 2023-"),
        "Error: Invalid date format '2023-'. Expected format: yyyy-mm-dd"
    );
}

#[test]
fn test_date_literal_missing_date() {
    assert_eq!(
        compile_graphql("created > 2023-05"),
        "Error: Invalid date format '2023-05'. Expected format: yyyy-mm-dd"
    );
}

#[test]
fn test_current_user_in_array() {
    assert_eq!(
        compile_with_user_context("bar", "assignee = (\"foo\",currentUser())")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(assigneeUsernames: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {"
    );
}
