pub mod test_helpers;

use crate::test_helpers::*;

#[test]
fn test_alias_labels() {
    assert_eq!(
        compile_graphql("labels = (\"foo\", \"bar\")")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(labelName: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("labels = @root"),
        "Error: `labels` cannot be compared with `@root`. Supported value types: `String`, `List`, `Nullable` (`null`, `none`, `any`), `Label` (example: `~frontend`)."
    );
}

#[test]
fn test_alias_createdat() {
    assert_eq!(
        compile_graphql("createdAt = \"2023-01-01\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-01-01 00:00\", createdBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("createdAt = @root"),
        "Error: `createdAt` cannot be compared with `@root`. Supported value types: `Date`."
    );
}

#[test]
fn test_alias_updatedat() {
    assert_eq!(
        compile_graphql("updatedAt = \"2023-01-01\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(updatedAfter: \"2023-01-01 00:00\", updatedBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("updatedAt = @root"),
        "Error: `updatedAt` cannot be compared with `@root`. Supported value types: `Date`."
    );
}

#[test]
fn test_alias_assignees() {
    assert_eq!(
        compile_graphql("assignees = (\"foo\", \"bar\")")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(assigneeUsernames: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("assignees = ~foo"),
        "Error: `assignees` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `List`, `Number`, `Nullable` (`null`, `none`, `any`)."
    );
}

#[test]
fn test_alias_healthstatus() {
    assert_eq!(
        compile_graphql("healthStatus = \"on track\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(healthStatusFilter: onTrack, before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("healthStatus = @root"),
        "Error: `healthStatus` cannot be compared with `@root`. Supported value types: `StringEnum` (`\"on track\"`, `\"needs attention\"`, `\"at risk\"`), `Nullable` (`null`, `none`, `any`)."
    );
}

#[test]
fn test_alias_closedat() {
    assert_eq!(
        compile_graphql("closedAt = \"2023-01-01\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(closedAfter: \"2023-01-01 00:00\", closedBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("closedAt = @root"),
        "Error: `closedAt` cannot be compared with `@root`. Supported value types: `Date`."
    )
}

#[test]
fn test_alias_duedate() {
    assert_eq!(
        compile_graphql("dueDate = \"2023-01-01\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(dueAfter: \"2023-01-01 00:00\", dueBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("dueDate = @root"),
        "Error: `dueDate` cannot be compared with `@root`. Supported value types: `Date`."
    );
}

#[test]
fn test_alias_openedat() {
    assert_eq!(
        compile_graphql("openedAt = \"2023-01-01\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  issues(createdAfter: \"2023-01-01 00:00\", createdBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("openedAt = @root"),
        "Error: `openedAt` cannot be compared with `@root`. Supported value types: `Date`."
    );
}

#[test]
fn test_alias_reviewers() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and reviewers = (\"foo\", \"bar\")"
        ),
        "Error: `reviewers` cannot be compared with `(\"foo\", \"bar\")`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and reviewers = ~foo"),
        "Error: `reviewers` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    );
}

#[test]
fn test_alias_reviewedby() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and reviewedBy = (\"foo\", \"bar\")"
        ),
        "Error: `reviewedBy` cannot be compared with `(\"foo\", \"bar\")`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and reviewedBy = ~foo"),
        "Error: `reviewedBy` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`)."
    );
}

#[test]
fn test_alias_mergedby() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and mergedBy = \"foo\""
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    mergeRequests(mergedBy: \"foo\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and mergedBy = ~root"),
        "Error: `mergedBy` cannot be compared with `~root`. Supported value types: `String`, `Username` (example: `@username`)."
    );
}

#[test]
fn test_alias_approvers() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and approvers = (\"foo\", \"bar\")"
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    mergeRequests(approvedBy: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and approvers = ~foo"),
        "Error: `approvers` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`), `List`."
    );
}

#[test]
fn test_alias_approvedby() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and approvedBy = (\"foo\", \"bar\")"
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    mergeRequests(approvedBy: [\"foo\", \"bar\"], before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and approvedBy = ~foo"),
        "Error: `approvedBy` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`), `List`."
    );
}

#[test]
fn test_alias_mergedat() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and mergedAt = \"2023-01-01\""
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    mergeRequests(mergedAfter: \"2023-01-01 00:00\", mergedBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and mergedAt = @root"),
        "Error: `mergedAt` cannot be compared with `@root`. Supported value types: `Date`."
    );
}

#[test]
fn test_alias_deployedat() {
    assert_eq!(
        compile_with_project_context(
            "gitlab-org/gitlab",
            "type = MergeRequest and deployedAt = \"2023-01-01\""
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    mergeRequests(deployedAfter: \"2023-01-01 00:00\", deployedBefore: \"2023-01-01 23:59\", before: $before, after: $after, first: $limit) {"
    );

    assert_eq!(
        compile_graphql("type = MergeRequest and deployedAt = @root"),
        "Error: `deployedAt` cannot be compared with `@root`. Supported value types: `Date`."
    );
}
