pub mod test_helpers;
use crate::test_helpers::compile_graphql;

macro_rules! test {
    ($($name:ident: ($input:expr, $expected:expr),)*) => { $(
        #[test]
        fn $name() {
            // test issues
            let compiled = compile_graphql(concat!("project = \"gitlab-org/gitlab\" and ", $input));
            assert_eq!(compiled.lines().nth(2).unwrap_or_else(|| compiled.as_str()), $expected);
        }
    )* }
}

test! {
    test_custom_field: (
        "customField(\"Subscription\") = \"Free\"",
        "    issues(before: $before, after: $after, first: $limit, customField: [{customFieldName: \"Subscription\", selectedOptionValues: \"Free\"}]) {"
    ),
    test_custom_field_with_list: (
        "customField(\"Subscription\") = (\"Free\", \"Paid\")",
        "    issues(before: $before, after: $after, first: $limit, customField: [{customFieldName: \"Subscription\", selectedOptionValues: [\"Free\", \"Paid\"]}]) {"
    ),
    test_custom_field_combined: (
        "customField(\"Subscription\") = \"Free\" and customField(\"Subscription\") = \"Paid\"",
        "    issues(before: $before, after: $after, first: $limit, customField: [{customFieldName: \"Subscription\", selectedOptionValues: [\"Free\", \"Paid\"]}]) {"
    ),
    test_multiple_custom_fields: (
        "customField(\"Subscription\") = \"Free\" and customField(\"Team\") = \"Green\"",
        "    issues(before: $before, after: $after, first: $limit, customField: [{customFieldName: \"Subscription\", selectedOptionValues: \"Free\"}, {customFieldName: \"Team\", selectedOptionValues: \"Green\"}]) {"
    ),

    test_custom_field_invalid_operator: (
        "customField(\"Subscription\") != \"Free\"",
        "Error: `customField(\"Subscription\")` does not support the not equals (`!=`) operator. Supported operators: equals (`=`)."
    ),

    test_custom_field_invalid_syntax_1: (
        "customField = \"Free\"",
        "Error: customField is not a recognized field."
    ),

    test_custom_field_invalid_syntax_2: (
        "customField(\"Subscription\", \"Team\") = \"Free\"",
        "Error: Unexpected number of arguments for function: `customField`. Expected: 1, Actual: 2"
    ),

    test_invalid_function_call: (
        "fooBar(\"Subscription\") = \"Free\"",
        "Error: Unrecognized function: fooBar(\"Subscription\")"
    ),
}
