pub mod test_helpers;

use crate::test_helpers::*;
use glql::utils::feature_flags::FeatureFlag;

#[test]
fn test_current_user_with_username() {
    assert_eq!(
        compile_with_user_context(
            "foo",
            "project = \"gitlab-org/gitlab\" and assignee = currentUser()"
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    issues(assigneeUsernames: \"foo\", before: $before, after: $after, first: $limit) {"
    );

    FeatureFlag::GlqlWorkItems.set(true);

    assert_eq!(
        compile_with_user_context(
            "foo",
            "project = \"gitlab-org/gitlab\" and assignee = currentUser()"
        )
        .lines()
        .nth(2)
        .unwrap(),
        "    workItems(assigneeUsernames: \"foo\", before: $before, after: $after, first: $limit) {"
    );
}

#[test]
fn test_default_group() {
    assert_eq!(
        compile_with_group_context("bar", "weight=1")
            .lines()
            .nth(1)
            .unwrap(),
        "  group(fullPath: \"bar\") {"
    );
}

#[test]
fn test_group_precedence() {
    assert_eq!(
        compile_with_group_context("bar", "group=\"foo\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  group(fullPath: \"foo\") {"
    );
}

#[test]
fn test_default_project() {
    assert_eq!(
        compile_with_project_context("bar", "weight=1")
            .lines()
            .nth(1)
            .unwrap(),
        "  project(fullPath: \"bar\") {"
    );
}

#[test]
fn test_project_precedence() {
    assert_eq!(
        compile_with_project_context("bar", "project=\"foo\"")
            .lines()
            .nth(1)
            .unwrap(),
        "  project(fullPath: \"foo\") {"
    );
}
