pub mod test_helpers;

use crate::test_helpers::compile_with_aggregate;

#[test]
fn test_aggregate_with_dimensions_and_metrics() {
    let query = "project = 'gitlab-org/gitlab' and type = MergeRequest and merged >= '2024-08-09' and merged <= '2025-08-08'";
    let dimensions = "timeSegment(1m) on merged";
    let metrics = "count, totalTimeToMerge";
    let result = compile_with_aggregate(query, dimensions, metrics);

    assert_eq!(
        result,
        r#"query GLQL {
  project(fullPath: "gitlab-org/gitlab") {
    from_2024_08_09_to_2024_09_01: mergeRequests(mergedAfter: "2024-08-09 00:00", mergedBefore: "2024-09-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2024_09_01_to_2024_10_01: mergeRequests(mergedAfter: "2024-09-01 00:00", mergedBefore: "2024-10-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2024_10_01_to_2024_11_01: mergeRequests(mergedAfter: "2024-10-01 00:00", mergedBefore: "2024-11-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2024_11_01_to_2024_12_01: mergeRequests(mergedAfter: "2024-11-01 00:00", mergedBefore: "2024-12-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2024_12_01_to_2025_01_01: mergeRequests(mergedAfter: "2024-12-01 00:00", mergedBefore: "2025-01-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_01_01_to_2025_02_01: mergeRequests(mergedAfter: "2025-01-01 00:00", mergedBefore: "2025-02-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_02_01_to_2025_03_01: mergeRequests(mergedAfter: "2025-02-01 00:00", mergedBefore: "2025-03-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_03_01_to_2025_04_01: mergeRequests(mergedAfter: "2025-03-01 00:00", mergedBefore: "2025-04-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_04_01_to_2025_05_01: mergeRequests(mergedAfter: "2025-04-01 00:00", mergedBefore: "2025-05-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_05_01_to_2025_06_01: mergeRequests(mergedAfter: "2025-05-01 00:00", mergedBefore: "2025-06-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_06_01_to_2025_07_01: mergeRequests(mergedAfter: "2025-06-01 00:00", mergedBefore: "2025-07-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_07_01_to_2025_08_01: mergeRequests(mergedAfter: "2025-07-01 00:00", mergedBefore: "2025-08-01 00:00", first: 0) {
      count
      totalTimeToMerge
    }
    from_2025_08_01_to_2025_08_08: mergeRequests(mergedAfter: "2025-08-01 00:00", mergedBefore: "2025-08-08 23:59", first: 0) {
      count
      totalTimeToMerge
    }
  }
}
"#
    );
}
