use TimeUnit::*;
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Debug, PartialEq, Clone, Serialize, Deserialize, Ord, PartialOrd, Eq)]
pub enum TimeUnit {
    Days,
    Weeks,
    Months,
    Years,
}

impl fmt::Display for TimeUnit {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self {
            Days => write!(f, "d"),
            Weeks => write!(f, "w"),
            Months => write!(f, "m"),
            Years => write!(f, "y"),
        }
    }
}
