use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Debug, Serialize, Deserialize, PartialEq, Clone, Eq, Ord, PartialOrd)]
pub struct Variable {
    pub key: String,
    pub r#type: String,
    pub value: Option<String>,
}

impl Variable {
    pub fn new(key: &str, r#type: &str) -> Self {
        Self {
            key: key.to_string(),
            r#type: r#type.to_string(),
            value: None,
        }
    }

    pub fn with_value(self, value: &str) -> Self {
        Self {
            value: Some(value.to_string()),
            ..self
        }
    }
}

impl fmt::Display for Variable {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "${}: {} ", self.key, self.r#type)
    }
}
