use crate::utils::feature_flags::FeatureFlag;
use Source::*;
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Debug, PartialEq, Clone, Serialize, Deserialize, Ord, PartialOrd, Eq)]
pub enum Source {
    Epics,
    Issues,
    MergeRequests,
}

impl From<String> for Source {
    fn from(s: String) -> Self {
        match s.to_lowercase().as_str() {
            "epic" => match FeatureFlag::GlqlWorkItems.get() {
                true => Issues,
                false => Epics,
            },
            "issue" | "incident" | "testcase" | "requirement" | "task" | "ticket" | "objective"
            | "keyresult" => Issues,
            "mergerequest" => MergeRequests,

            _ => Issues,
        }
    }
}

impl From<&str> for Source {
    fn from(s: &str) -> Self {
        s.to_string().into()
    }
}

impl fmt::Display for Source {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self {
            Epics => write!(f, "epics"),
            Issues => write!(f, "work items"),
            MergeRequests => write!(f, "merge requests"),
        }
    }
}
