use ReferenceType::*;
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Debug, PartialEq, Clone, Serialize, Deserialize, Ord, PartialOrd, Eq)]
pub enum ReferenceType {
    UserRef,
    MilestoneRef,
    LabelRef,
    IterationRef,
    EpicRef,
}

impl ReferenceType {
    pub fn symbol(&self) -> String {
        match self {
            UserRef => "@",
            MilestoneRef => "%",
            LabelRef => "~",
            IterationRef => "*iteration:",
            EpicRef => "&",
        }
        .into()
    }
}

impl fmt::Display for ReferenceType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}",
            match self {
                UserRef => "`Username` (example: `@username`)",
                MilestoneRef => "`Milestone` (example: `%Backlog`)",
                LabelRef => "`Label` (example: `~frontend`)",
                IterationRef => "`Iteration` (example: `*iteration:25263`",
                EpicRef => "`Epic` (example: `&123` or `group-path&123`)",
            }
        )
    }
}
