use crate::types::{Expression, Field, Value};
use serde::{Deserialize, Serialize};

#[derive(Debug, PartialEq, Clone, Eq, Serialize, Deserialize)]
pub struct Query {
    pub expressions: Vec<Expression>,
}

impl Query {
    pub fn new(expressions: Vec<Expression>) -> Self {
        Query { expressions }
    }

    pub fn contains_field(&self, field: &Field) -> bool {
        self.expressions
            .iter()
            .any(|expr| expr.field.dealias() == field)
    }

    pub fn contains_field_with_value(&self, field: &Field, value: &Value) -> bool {
        self.expressions
            .iter()
            .any(|expr| expr.field.dealias() == field && expr.value == *value)
    }
}
