use Operator::*;
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Debug, PartialEq, Eq, Hash, Clone, Serialize, Deserialize, PartialOrd, Ord)]
pub enum Operator {
    In,
    Equal,
    NotEqual,
    GreaterThan,
    GreaterThanEquals,
    LessThan,
    LessThanEquals,
}

impl fmt::Display for Operator {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}",
            match self {
                In => "is one of (`in`)",
                Equal => "equals (`=`)",
                NotEqual => "not equals (`!=`)",
                GreaterThan => "greater than (`>`)",
                GreaterThanEquals => "greater than or equal to (`>=`)",
                LessThan => "less than (`<`)",
                LessThanEquals => "less than or equal to (`<=`)",
            }
        )
    }
}
