pub use compile_context::*;
pub use compile_output::*;
pub use context::*;
pub use display_field::*;
pub use expression::*;
pub use field::*;
pub use field_type::*;
pub use operator::*;
pub use query::*;
pub use reference_type::*;
pub use relationship_type::*;
pub use sort::*;
pub use source::*;
pub use transform_context::*;
pub use transform_output::*;
pub use value::*;
pub use variable::*;

pub mod aggregation;
mod compile_context;
mod compile_output;
mod context;
mod display_field;
mod expression;
mod field;
mod field_type;
mod operator;
mod query;
mod reference_type;
mod relationship_type;
mod sort;
mod source;
mod transform_context;
mod transform_output;
mod value;
mod variable;

// Field mapping abstraction for handling different API implementations
#[derive(Debug, Clone)]
pub struct FieldMapping {
    pub field_type: FieldType,
    pub variable_type: String, // GraphQL variable type for subqueries
    pub get_attribute: fn(&FieldType, &Value) -> String, // Function to get attribute based on field type and value
}

#[derive(Debug, PartialEq, Clone)]
pub enum HealthStatus {
    OnTrack,
    NeedsAttention,
    AtRisk,
}

#[derive(Debug)]
pub struct HealthStatusConvertError;

// Convert from user input (String) to HealthStatus
impl TryFrom<&str> for HealthStatus {
    type Error = HealthStatusConvertError;

    fn try_from(value: &str) -> Result<Self, Self::Error> {
        match value.to_lowercase().as_str() {
            "on track" => Ok(Self::OnTrack),
            "needs attention" => Ok(Self::NeedsAttention),
            "at risk" => Ok(Self::AtRisk),
            _ => Err(HealthStatusConvertError),
        }
    }
}
