use crate::types::{Field, Operator, Value};
use serde::{Deserialize, Serialize};

#[derive(Debug, PartialEq, Clone, Eq, Serialize, Deserialize)]
pub struct Expression {
    pub field: Field,
    pub operator: Operator,
    pub value: Value,
}

impl Expression {
    pub fn new(field: Field, operator: Operator, value: Value) -> Self {
        Expression {
            field,
            operator,
            value,
        }
    }
}
