use crate::types::aggregation::AggregationCompileContext;
use crate::utils::feature_flags::FeatureFlags;
use serde::Deserialize;

#[derive(Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct CompileContext {
    pub username: Option<String>,
    pub fields: String,
    pub group: Option<String>,
    pub project: Option<String>,
    pub sort: Option<String>,
    pub feature_flags: Option<FeatureFlags>,
    pub aggregate: Option<AggregationCompileContext>,
}
