use crate::types::aggregation::{DimensionSegment, DimensionSegment::*};
use crate::types::{
    DisplayField::{self, *},
    Field::*,
};
use serde::{Deserialize, Serialize};

#[derive(Debug, PartialEq, Clone, Serialize, Deserialize, Ord, PartialOrd, Eq)]
pub struct Dimension {
    pub segment: DimensionSegment,
    pub field: DisplayField,
}

impl Default for Dimension {
    fn default() -> Self {
        Self {
            segment: UnknownSegment,
            field: Static(UnknownField("unknown".to_string())),
        }
    }
}

impl Dimension {
    pub fn segment(segment: DimensionSegment) -> Self {
        Self {
            segment,
            field: Static(UnknownField("unknown".to_string())),
        }
    }

    pub fn on(self, field: DisplayField) -> Self {
        Self { field, ..self }
    }
}
