use crate::errors::GlqlError;
use crate::parser::{parse_dimensions, parse_fields};
use crate::types::DisplayField;
use crate::types::aggregation::{AggregationCompileContext, Dimension};
use serde::{Deserialize, Serialize};

#[derive(Debug, PartialEq, Clone, Serialize, Deserialize, Ord, PartialOrd, Eq)]
pub struct AggregationContext {
    pub dimensions: Vec<Dimension>,
    pub metrics: Vec<DisplayField>,
}

impl TryFrom<AggregationCompileContext> for AggregationContext {
    type Error = GlqlError;

    fn try_from(value: AggregationCompileContext) -> Result<Self, Self::Error> {
        Ok(Self {
            dimensions: parse_dimensions(value.dimensions.as_str())?,
            metrics: parse_fields(value.metrics.as_str())?,
        })
    }
}
