pub mod context;
pub mod data;
pub mod expression;
pub mod field_functions;
pub mod functions;

use crate::types::{Context, Query};
use expression::{combine_expressions, expand_expression, transform_expression};

pub fn transform(query: &Query, context: &Context) -> Query {
    let mut query = query.clone();
    let source = context.source.as_ref().expect("Source is required");
    query.expressions = combine_expressions(
        query
            .expressions
            .iter()
            .flat_map(|expr| expand_expression(expr, source))
            .map(|expr| transform_expression(&expr, source))
            .collect(),
    );
    query
}
