use super::{
    literals::{array, bool, function, null, number, string},
    special::{date, epic, iteration, label, milestone, relative_date, token, username},
};
use crate::errors::GlqlError;
use crate::types::Value;
use nom::{IResult, branch::alt};

// Main value parser
pub fn value(input: &str) -> IResult<&str, Value, GlqlError> {
    alt((non_array_value, array))(input)
}

pub fn non_array_value(input: &str) -> IResult<&str, Value, GlqlError> {
    alt((
        null,
        bool,
        relative_date,
        date,
        username,
        milestone,
        label,
        iteration,
        epic,
        string,
        number,
        function,
        token,
    ))(input)
}
