use crate::{
    types::{
        FieldType::{self, *},
        Operator::*,
        RelationshipType::*,
    },
    utils::feature_flags::FeatureFlag,
};

pub fn type_field_type() -> FieldType {
    let mut work_item_types = vec![
        "Issue",
        "Incident",
        "TestCase",
        "Requirement",
        "Task",
        "Ticket",
        "Objective",
        "KeyResult",
    ];
    let mut other_types = vec!["MergeRequest"];

    if FeatureFlag::GlqlWorkItems.get() {
        work_item_types.push("Epic");
    } else {
        other_types.insert(0, "Epic");
    }

    let enum_types: Vec<String> = [work_item_types.as_slice(), other_types.as_slice()]
        .concat()
        .iter()
        .map(|&t| t.to_string())
        .collect();

    let list_enum_types: Vec<String> = work_item_types
        .as_slice()
        .iter()
        .map(|&t| t.to_string())
        .collect();

    EnumLike(enum_types).with_ops([Equal])
        | ListLike(HasOne, Box::new(EnumLike(list_enum_types))).with_ops([In])
}
