use crate::{
    analyzer::field::FieldAnalyzer,
    analyzer::value::ValueAnalyzer,
    errors::GlqlError,
    types::{Expression, Source},
};

pub struct ExpressionAnalyzer {
    expression: Expression,
    source: Source,
}

impl ExpressionAnalyzer {
    pub fn new(expression: Expression, source: Source) -> Self {
        Self { expression, source }
    }

    pub fn analyze(&self) -> Result<(), GlqlError> {
        FieldAnalyzer::new(self.expression.field.clone(), self.source.clone())
            .analyze(&self.expression.operator, &self.expression.value)?;

        ValueAnalyzer::new(self.expression.value.clone(), self.source.clone())
            .analyze(&self.expression.field)?;

        Ok(())
    }
}
