use crate::{
    analyzer::sort::SortAnalyzer,
    errors::GlqlError,
    types::{Context, Source},
};

pub struct ContextAnalyzer {
    context: Context,
    source: Source,
}

impl ContextAnalyzer {
    pub fn new(context: Context, source: Source) -> Self {
        Self { context, source }
    }

    pub fn analyze(&self) -> Result<(), GlqlError> {
        if let Some(sort) = &self.context.sort {
            SortAnalyzer::new(sort.clone(), self.source.clone()).analyze()?;
        }

        Ok(())
    }
}
