#!/bin/sh
set -e

QUERY=$(cat << 'EOF'
query {
  project(fullPath: "gitlab-org/gitlab") {
    pipelines(ref: "master", status: SUCCESS) {
      nodes {
        job(name: "graphql-schema-dump") {
          id
        }
      }
    }
  }
}
EOF
)

response=$(curl -s -X POST \
  -H "Content-Type: application/json" \
  -d "$(jq -n --arg query "$QUERY" '{query: $query}')" \
  https://gitlab.com/api/graphql)

job_id=$(echo "$response" | jq -r '.data.project.pipelines.nodes[].job.id // empty' | head -n 1 | sed 's/gid:\/\/gitlab\/Ci::Build\///')

if [ -z "$job_id" ]; then
    echo "Error: Could not extract job ID from response"
    echo "Response: $response"
    exit 1
fi

echo "Found job ID: $job_id"

OUTPUT="tmp/gitlab_schema.graphql"

mkdir -p tmp

# Fetch the schema file using the job ID
echo "Fetching schema file..."
curl -o $OUTPUT "https://gitlab.com/gitlab-org/gitlab/-/jobs/${job_id}/artifacts/raw/tmp/tests/graphql/gitlab_schema.graphql"

echo "Schema file has been saved to $OUTPUT"
