import resolve from '@rollup/plugin-node-resolve';
import commonjs from '@rollup/plugin-commonjs';
import { wasm } from '@rollup/plugin-wasm';
import json from '@rollup/plugin-json';
import typescript from '@rollup/plugin-typescript';
import { readFileSync } from 'fs';
import replace from '@rollup/plugin-replace';
import path from 'path';

const pkg = JSON.parse(readFileSync('package.json', { encoding: 'utf8' }));

export default [
  {
    input: 'npm/src/index.ts',
    output: [
      {
        file: pkg.module,
        format: 'esm',
        sourcemap: true,
      },
    ],
    plugins: [
      resolve(),
      commonjs(),
      typescript({
        tsconfig: './tsconfig.json',
        declaration: true,
        sourceMap: true,
        outDir: path.dirname(pkg.module),
        inlineSources: true,
      }),
      wasm({
        targetEnv: 'auto-inline',
      }),
      replace({
        'process.env.NODE_ENV': JSON.stringify('production'),
        'import.meta.url': JSON.stringify(''),
      }),
      json(),
    ],
  },
];
