import { glql } from '../src/index';
import { formatSdl } from 'format-graphql';

// Define interfaces for the test utilities
interface CompileOptions {
  fields?: string[];
  group?: string;
  sort?: string;
  useWorkItemsAPI?: boolean;
  aggregate?: {
    dimensions: string;
    metrics: string;
  };
}

interface CompileResult {
  output: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  variables?: any;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  [key: string]: any;
}

interface TransformOptions {
  fields?: string[];
  useWorkItemsAPI?: boolean;
}

export async function compileToGraphql(
  query: string,
  {
    fields = ['id', 'title'],
    group = 'gitlab-org',
    sort,
    useWorkItemsAPI = false,
  }: CompileOptions = {},
): Promise<CompileResult> {
  const result = await glql.compile(query, {
    username: 'foo',
    fields: fields.join(','),
    group,
    sort,
    featureFlags: {
      glqlWorkItems: useWorkItemsAPI,
      glqlTypescript: Boolean(process.env['USE_TYPESCRIPT']),
    },
  });

  return {
    ...result,
    output: formatSdl(result.output || ''),
  };
}

export async function transformData(
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  data: Record<string, any>,
  { fields = ['id', 'title'] }: TransformOptions = {},
) {
  return await glql.transform(data, {
    fields: fields.join(','),
  });
}

export function mockCurrentDate(): void {
  jest.useFakeTimers().setSystemTime(new Date('2024-01-01'));
}
