import { featureFlags } from '../../src/utils/feature_flags';
import { compileGraphQL } from './test_helpers';

test.each([
  [
    'weight = null',
    ['    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
    ['    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight = none',
    ['    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
    ['    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight != 2',
    ['    issues(not: {weight: "2"}, before: $before, after: $after, first: $limit) {'],
    ['    workItems(not: {weight: "2"}, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight = any',
    ['    issues(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {'],
    ['    workItems(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight != any',
    ['    issues(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
    ['    workItems(weightWildcardId: NONE, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight != none',
    ['    issues(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {'],
    ['    workItems(weightWildcardId: ANY, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'weight = 2',
    ['    issues(weight: "2", before: $before, after: $after, first: $limit) {'],
    ['    workItems(weight: "2", before: $before, after: $after, first: $limit) {'],
  ],
])('%s', (query, expectedIssues, expectedWorkItems) => {
  featureFlags.glqlWorkItems = false;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedIssues),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedWorkItems),
  );
});
