import { featureFlags } from '../../src/utils/feature_flags';
import { compileWithProjectContext } from './test_helpers';

it.each`
  field          | value         | outputToken
  ${'Milestone'} | ${'Upcoming'} | ${'UPCOMING'}
  ${'mIlEsToNe'} | ${'Started'}  | ${'STARTED'}
  ${'milestone'} | ${'any'}      | ${'ANY'}
  ${'milestone'} | ${'none'}     | ${'NONE'}
  ${'ITERATION'} | ${'current'}  | ${'CURRENT'}
  ${'iteration'} | ${'any'}      | ${'ANY'}
  ${'iterATION'} | ${'none'}     | ${'NONE'}
  ${'Assignee'}  | ${'nOnE'}     | ${'NONE'}
  ${'assignee'}  | ${'any'}      | ${'ANY'}
`('valid query: $field = $value', ({ field, value, outputToken }) => {
  expect(
    compileWithProjectContext('gitlab-org/gitlab', `${field} = ${value} and state = opened`).split(
      '\n',
    ),
  ).toEqual(
    expect.arrayContaining([
      `    issues(`,
      `      ${field.toLowerCase()}WildcardId: ${outputToken}`,
      `      state: opened`,
      `      before: $before`,
      `      after: $after`,
      `      first: $limit`,
      `    ) {`,
    ]),
  );

  featureFlags.glqlWorkItems = true;

  expect(
    compileWithProjectContext('gitlab-org/gitlab', `${field} = ${value} and state = opened`).split(
      '\n',
    ),
  ).toEqual(
    expect.arrayContaining([
      `    workItems(`,
      `      ${field.toLowerCase()}WildcardId: ${outputToken}`,
      `      state: opened`,
      `      before: $before`,
      `      after: $after`,
      `      first: $limit`,
      `    ) {`,
    ]),
  );
});

it.each`
  query                    | expectedError
  ${'Milestone = Current'} | ${'Error: `Milestone` cannot be compared with `Current`. Supported value types: `String`, `List`, `Nullable` (`null`, `none`, `any`), `Enum` (`upcoming`, `started`), `Milestone` (example: `%Backlog`).'}
`('invalid query: $query', ({ query, expectedError }) => {
  expect(compileWithProjectContext('gitlab-org/gitlab', query)).toEqual(expectedError);
});

it.each`
  labelWildcard
  ${'any'}
  ${'none'}
  ${'AnY'}
  ${'None'}
`('valid query: label = $labelWildcard', ({ labelWildcard }) => {
  expect(
    compileWithProjectContext('gitlab-org/gitlab', `label = ${labelWildcard}`).split('\n'),
  ).toEqual(
    expect.arrayContaining([
      `    issues(labelName: "${labelWildcard.toUpperCase()}", before: $before, after: $after, first: $limit) {`,
    ]),
  );

  featureFlags.glqlWorkItems = true;

  expect(
    compileWithProjectContext('gitlab-org/gitlab', `label = ${labelWildcard}`).split('\n'),
  ).toEqual(
    expect.arrayContaining([
      `    workItems(labelName: "${labelWildcard.toUpperCase()}", before: $before, after: $after, first: $limit) {`,
    ]),
  );
});
