import { featureFlags } from '../../src/utils/feature_flags';
import { compileWithProjectContext } from './test_helpers';

test('status equals something', () => {
  expect(compileWithProjectContext('gitlab-org/gitlab', "status = 'Start'").split('\n')).toEqual(
    expect.arrayContaining([
      '    issues(status: {name: "Start"}, before: $before, after: $after, first: $limit) {',
    ]),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileWithProjectContext('gitlab-org/gitlab', "status = 'Start'").split('\n')).toEqual(
    expect.arrayContaining([
      '    workItems(',
      '      status: {name: "Start"}',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ]),
  );
});

test('status not equals something', () => {
  expect(compileWithProjectContext('gitlab-org/gitlab', "status != 'Start'")).toEqual(
    'Error: `status` does not support the not equals (`!=`) operator. Supported operators: equals (`=`).',
  );
});
