import { featureFlags } from '../../src/utils/feature_flags';
import { compileWithProjectContext } from './test_helpers';

test.each([
  [
    'opened > 2024-02-01',
    [
      '    issues(',
      '      createdAfter: "2024-02-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      createdAfter: "2024-02-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'opened < 2024-02-01',
    [
      '    issues(',
      '      createdBefore: "2024-02-01 00:00"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      createdBefore: "2024-02-01 00:00"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'closed > 2024-02-01',
    [
      '    issues(',
      '      closedAfter: "2024-02-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      closedAfter: "2024-02-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'closed < 2024-02-01',
    [
      '    issues(',
      '      closedBefore: "2024-02-01 00:00"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      closedBefore: "2024-02-01 00:00"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'state = opened',
    ['    issues(state: opened, before: $before, after: $after, first: $limit) {'],
    ['    workItems(state: opened, before: $before, after: $after, first: $limit) {'],
  ],
  [
    'state = closed',
    ['    issues(state: closed, before: $before, after: $after, first: $limit) {'],
    ['    workItems(state: closed, before: $before, after: $after, first: $limit) {'],
  ],
])('%s', (query, issues, workItems) => {
  expect(compileWithProjectContext('gitlab-org/gitlab', query).split('\n')).toEqual(
    expect.arrayContaining(issues),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileWithProjectContext('gitlab-org/gitlab', query).split('\n')).toEqual(
    expect.arrayContaining(workItems),
  );
});

it.each`
  query                  | expectedError
  ${'state != opened'}   | ${'Error: `state` does not support the not equals (`!=`) operator. Supported operators: equals (`=`).'}
  ${"state = 'invalid'"} | ${'Error: `state` cannot be compared with `"invalid"`. Supported value types: `Enum` (`opened`, `closed`, `all`).'}
  ${'opened = true'}     | ${'Error: `opened` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?'}
  ${'opened = false'}    | ${'Error: `opened` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = closed`?'}
  ${'closed = true'}     | ${'Error: `closed` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = closed`?'}
  ${'closed = false'}    | ${'Error: `closed` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = opened`?'}
  ${'created = true'}    | ${'Error: `created` cannot be compared with `true`. Supported value types: `Date`. Did you mean `state = opened`?'}
  ${'created = false'}   | ${'Error: `created` cannot be compared with `false`. Supported value types: `Date`. Did you mean `state = closed`?'}
`('invalid query: $query', ({ query, expectedError }) => {
  expect(compileWithProjectContext('gitlab-org/gitlab', query)).toEqual(expectedError);
});
