import { compileGraphQL } from './test_helpers';

test.each([
  ['weight = 1', ['  issues(weight: "1", before: $before, after: $after, first: $limit) {']],
  [
    "project = 'gitlab-org/gitlab'",
    [
      '  project(fullPath: "gitlab-org/gitlab") {',
      '    issues(before: $before, after: $after, first: $limit) {',
    ],
  ],
  [
    "group = 'gitlab-org'",
    [
      '  group(fullPath: "gitlab-org") {',
      '    issues(before: $before, after: $after, first: $limit, includeSubgroups: true) {',
    ],
  ],
  [
    "group = 'gitlab-org' and includeSubgroups = true",
    [
      '  group(fullPath: "gitlab-org") {',
      '    issues(includeSubgroups: true, before: $before, after: $after, first: $limit) {',
    ],
  ],
  [
    "group = 'gitlab-org' and includeSubgroups = false",
    [
      '  group(fullPath: "gitlab-org") {',
      '    issues(includeSubgroups: false, before: $before, after: $after, first: $limit) {',
    ],
  ],
  [
    'project = "gitlab-org/gitlab" and includeSubgroups = true',
    ['Error: `includeSubgroups` can only be used with: `group`.'],
  ],
  [
    'group = "gitlab-org" and includeSubgroups = "wrong"',
    [
      'Error: `includeSubgroups` cannot be compared with `"wrong"`. Supported value types: `Boolean` (`true`, `false`).',
    ],
  ],
  [
    'group="gitlab-org" and project="gitlab-org/gitlab"',
    [
      '  project(fullPath: "gitlab-org/gitlab") {',
      '    issues(before: $before, after: $after, first: $limit) {',
    ],
  ],
])('%s', (query, expected) => {
  expect(compileGraphQL(query).split('\n')).toEqual(expect.arrayContaining(expected));
});
